//
//  MCStackResultsPane.h
//  MCApplication
//
//  Created by Ali Lalani on 8/27/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import "MCStackTabbedPane.h"
#import "MCSourceListsResultsController.h"
#import "MCMenuManagerSupportProtocol.h"

@interface MCStackResultsPane : MCStackTabbedPane <MCMenuManagerSupport>{
	NSArray *sourceLists;
	MCSourceListsResultsController *resultsController;
	NSArray *selectedResults;

	// If this is YES, changes in the results selection(observe method) will be ignored
	BOOL suspendResultsSelectionChange;

	NSString *filterString;

	NSString *sortableColumnsConfigurationIdentifier;
	NSArray *sortDescriptors;
	
	NSMenu *listMenu;
}
- (IBAction)openObject:(id)sender;

- (void)resultsSelectionDidChange;
- (void)postDidShowObjectsNotification;

- (void)selectObjects:(NSArray *)anArray;

- (void)performFilterForString:(NSString *)str;

- (BOOL)dumbListSelected;

- (BOOL)suspendResultsSelectionChange;

- (id)predicateForFilterString;
- (BDQualifier *)qualifierForFilterString;

// This is the currently active table view/outline view
- (id)resultsTable;

#pragma mark RepresentedMenuCommandSupport
- (BOOL)validatedRepresentedCommandInMenuItem:(id <NSMenuItem>)menuItem;

#pragma mark DisplayStateReadWrite
- (void)writeSelectedResultsToDisplayState;
- (void)readSelectedResultsFromDisplayState;
- (void)readSortDescriptorsFromDisplayState;
- (void)writeSortDescriptorsToDisplayState;

#pragma mark Accessors
// Array of arrays, each array is a batch of objects that are selected in the results pane
// if the reciever of a results changed notification cares about displaying consolidated results
// they can flatten the array
- (NSArray *)selectedResults;
- (void)setSelectedResults:(NSArray *)aSelectedResults;

- (MCSourceListsResultsController *)resultsController;
- (void)setResultsController:(MCSourceListsResultsController *)aResultsController;

- (NSArray *)sourceLists;
- (void)setSourceLists:(NSArray *)aSourceLists;

- (NSString *)filterString;
- (void)setFilterString:(NSString *)aFilterString;

- (NSArray *)sortDescriptors;
- (void)setSortDescriptors:(NSArray *)aSortDescriptors;

- (NSString *)sortableColumnsConfigurationIdentifier;
- (void)setSortableColumnsConfigurationIdentifier:(NSString *)aSortableColumnsConfigurationIdentifier;

- (NSMenu *)listMenu;
- (void)setListMenu:(NSMenu *)aListMenu;
@end
